@extends('layouts.app')
@section('title', 'Images | Project Details')

@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.css">
<div class="d-flex flex-column flex-column-fluid">
    <style>
        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

        iframe {
            width: 100% !important;
            height: 300px !important;
            margin: 0 !important;
            border-radius: 10px;
        }

        .nav-link {
            font-size: 18px;
            color: #5E5E5E;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            border: 1px solid #93D50066;
            background: white;
            color: black;
            font-weight: 500;
        }

        .page-heading {
            font-size: 24px !important;
        }

        .project-id {
            font-size: 18px;
            color: #556171 !important;
        }

        .dropzone {
            border: 2px dashed #007bff;
            border-radius: 5px;
            background: #f8f9fa;
            padding: 0 !important;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            cursor: pointer;
        }

        .dropzone .dz-message {
            font-size: 20px;
            font-weight: bold;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .dropzone .dz-message img {
            max-width: 100px;
            margin-bottom: 20px;
        }

        .dropzone .dz-message h3 {
            font-size: 24px;
            margin: 10px 0;
        }

        .dropzone .dz-message p {
            font-size: 16px;
            color: #6c757d;
        }

        .uploaded-files {
            margin-top: 20px;
        }

        .uploaded-file {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 10px;
            background: #fff;
            padding: 15px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            width: 100%;
        }

        .uploaded-file .file-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
        }

        .uploaded-file img {
            max-width: 50px;
            margin-right: 15px;
        }

        .uploaded-file .file-name {
            flex-grow: 1;
        }

        .uploaded-file .progress {
            width: 100%;
            background: #e9ecef;
            border-radius: 5px;
            overflow: hidden;
            margin: 10px 0;
        }

        .uploaded-file .progress-bar {
            height: 10px;
            background: #007bff;
            transition: width 0.4s;
        }

        .uploaded-file .notes {
            width: 100%;
            margin: 10px 0;
        }

        .nav-pills .nav-link {
            font-size: 16px;
        }

        .uploaded-file .save-notes {
            background: #28a745;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
        }

        .fixed-width {
            width: 200px;
            /* Adjust this as needed */
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .file-name {
            font-size: 17px;
            font-weight: 500;
        }

        .image-box {
            background: #EEEEEE;
            padding: 20px;
            border-radius: 10px;
        }

        .image-box a {
            color: #3C72FF !important;
        }

        .image-box p {
            color: #5E5E5E;
        }

        .img-fluid {
            width: 100%;
            height: 190px;
            object-fit: cover;
            border-radius: 10px;
        }

        .more-images {
            position: absolute;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            color: white;
            display: flex;
            top: 0;
            border-radius: 10px;
            justify-content: center;
            align-items: center;
            font-size: 20px;
        }

        .form-check-input:checked {
            border-color: #93d500;
        }

        .form-check {
            display: none;
        }

    </style>
    @include('project.head')
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="row align-items-center mb-7">
                <div class="col-md-12">
                    @include('project.nav')
                </div>

            </div>


            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif

            <div class="card mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <i class="ki-outline ki-picture fs-1 me-2"></i>
                        <h3 class="fw-bold">Images
                            <button data-bs-toggle="modal" data-bs-target="#kt_modal_new_target" class="btn btn-sm btn-primary align-self-center ms-3">Add Images</button>
                        </h3>
                    </div>

                    <button id="report" class="btn btn-sm btn-primary align-self-center">Report</button>
                    <!--end::Card title-->
                </div>


                <div class="card-body">

                    <div style="display:none" class="mb-7 " id="report_btns">
                        <div class="row">
                            <div class="col-md-3">
                                <select name="" class="form-select" id="">
                                    <option value="">Images per screen</option>
                                </select>
                            </div>
                            <div class="col-md-9">
                                <div class="float-end">
                                    <button class="btn btn-primary" id="clearAll">Clear</button>
                                    <button class="btn btn-primary" id="selectAll">Select All Images</button>
                                    <button class="btn btn-primary" id="export">Export Report</button>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div>

                    </div>

                    <div class="image-box mb-7">
                        <p style="font-size:16px;font-weight:500"><a href="{{route('project.showBeforeImages', ['id'=>$project->id])}}">Before</a> <span class="float-end"></span></p>
                        @php
                        $totalImages = count($before_images);
                        @endphp


                        <div class="row">
                            @for ($i = 0; $i < 4; $i++) @if (isset($before_images[$i])) <div class="col-md-3">
                                <div style="position:relative">
                                    <img class="img-fluid" src="{{ asset('img/projects/'.$before_images[$i]->file) }}" alt="Image {{ $i + 1 }}">



                                    <div class="form-check me-2" style="position:absolute;top:10px;right:0">
                                        <input name="before[]" class="form-check-input" type="checkbox" value="{{$before_images[$i]->id}}" id="flexCheckDefault">

                                    </div>



                                    @if($i==3 && $totalImages>4)
                                    <div class="more-images">
                                        +{{ $totalImages - 4 }}
                                    </div>
                                    @endif
                                </div>
                        </div>
                        @else
                        <div class="col-md-3">
                            <img src="{{asset('img/comming_soon.svg')}}" class="img-fluid" alt="">
                        </div>
                        @endif
                        @endfor
                    </div>
                </div>
                <div class="image-box mb-7">
                    <p style="font-size:16px;font-weight:500"><a href="{{route('project.showFirstSiteImages', ['id'=>$project->id])}}">1st Site Visit</a> <span class="float-end"><a href="#!"><i class="fas fa-download"></i> Download Images</a></span></p>
                    @php
                    $totalImages = count($first_site_visit);
                    @endphp


                    <div class="row">
                        @for ($i = 0; $i < 4; $i++) @if (isset($first_site_visit[$i])) <div class="col-md-3">
                            <div style="position:relative">
                                <img class="img-fluid" src="{{ asset('img/projects/'.$first_site_visit[$i]->file) }}" alt="Image {{ $i + 1 }}">

                                <div class="form-check me-2" style="position:absolute;top:10px;right:0">
                                    <input name="first_site[]" class="form-check-input" type="checkbox" value="{{$first_site_visit[$i]->id}}" id="flexCheckDefault">

                                </div>

                                @if($i==3 && $totalImages>4)
                                <div class="more-images">
                                    +{{ $totalImages - 4 }}
                                </div>
                                @endif
                            </div>
                    </div>
                    @else
                    <div class="col-md-3">
                        <img src="{{asset('img/comming_soon.svg')}}" class="img-fluid" alt="">
                    </div>
                    @endif
                    @endfor
                </div>
            </div>
            <div class="image-box mb-7">
                <p style="font-size:16px;font-weight:500"><a href="{{route('project.showDuringImages', ['id'=>$project->id])}}">During</a> <span class="float-end"><a href="#!"><i class="fas fa-download"></i> Download Images</a></span></p>
                @php
                $totalImages = count($during);
                @endphp


                <div class="row">
                    @for ($i = 0; $i < 4; $i++) @if (isset($during[$i])) <div class="col-md-3">
                        <div style="position:relative">
                            <img class="img-fluid" src="{{ asset('img/projects/'.$during[$i]->file) }}" alt="Image {{ $i + 1 }}">

                            @if($i==3 && $totalImages>4)
                            <div class="more-images">
                                +{{ $totalImages - 4 }}
                            </div>
                            @endif
                        </div>
                </div>
                @else
                <div class="col-md-3">
                    <img src="{{asset('img/comming_soon.svg')}}" class="img-fluid" alt="">
                </div>
                @endif
                @endfor
            </div>
        </div>
        <div class="image-box mb-7">
            <p style="font-size:16px;font-weight:500"><a href="{{route('project.showCompletedImages', ['id'=>$project->id])}}">Project Completed</a>
                <span class="float-end"><a href="#!"><i class="fas fa-download"></i> Download Images</a></span>
            </p>
            @php
            $totalImages = count($completed);
            @endphp


            <div class="row">
                @for ($i = 0; $i < 4; $i++) @if (isset($completed[$i])) <div class="col-md-3">
                    <div style="position:relative">
                        <img class="img-fluid" src="{{ asset('img/projects/'.$completed[$i]->file) }}" alt="Image {{ $i + 1 }}">

                        @if($i==3 && $totalImages>4)
                        <div class="more-images">
                            +{{ $totalImages - 4 }}
                        </div>
                        @endif
                    </div>
            </div>
            @else
            <div class="col-md-3">
                <img src="{{asset('img/comming_soon.svg')}}" class="img-fluid" alt="">
            </div>
            @endif
            @endfor
        </div>
    </div>
</div>



</div>



</div>
</div>
<!--end::Content-->
</div>


<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form id="form-data" action="{{route('project.uploadProjectImages', ['id'=>$project->id])}}" method="post">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Images</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Type</span>
                        </label>
                        <!--end::Label-->
                        <select id="images_type" name="type" class="form-select  form-select-lg fw-semibold">
                            <option value="">Select</option>
                            <option value="before">Before</option>
                            <option value="1st_site_visit">1st Site Visit</option>
                            <option value="during">During</option>
                            <option value="project_completed">Project Completed</option>
                        </select>
                    </div>

                    <div class="d-flex flex-column mb-8 fv-row" style="display:none" id="zone">
                        <div class="dropzone" id="my-dropzone">
                            <div class="dz-message">
                                <img src="{{asset('img/cloud.svg')}}" alt="Upload">
                                <h3>Upload Images</h3>
                                <p>Browse or drag images to begin</p>
                            </div>
                        </div>
                    </div>






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<form action="{{route('project.exportImages', ['id'=>$project->id])}}" method="post" style="display:none" id="exportForm">
    @csrf
    <input type="hidden" name="before_images" id="before_images">
    <input type="hidden" name="first_site" id="first_site">
</form>

@endsection


@section('js')


<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#selectAll').click(function() {
            $('input[name="before[]"]').prop('checked', true);
            $('input[name="first_site[]"]').prop('checked', true);
        });
    });

    $(document).ready(function() {
        $('#clearAll').click(function() {
            $('input[name="before[]"]').prop('checked', false);
            $('input[name="first_site[]"]').prop('checked', false);
            $("#report_btns").hide();
            $("#kt_chat_contacts_header").show();
        });
    });


    $("#export").click(function() {

        //BEFORE
        var checkboxValues = $('input[name^="before\\[\\]"]:checked').map(function() {
            return $(this).val();
        }).get();
        var commaSeparatedValues = checkboxValues.join(',');
        $('#before_images').val(commaSeparatedValues);


        //FIRST SITE

        var checkboxValues = $('input[name^="first_site\\[\\]"]:checked').map(function() {
            return $(this).val();
        }).get();
        var commaSeparatedValues = checkboxValues.join(',');
        $('#first_site').val(commaSeparatedValues);

        $("#exportForm").submit();

    });

    Dropzone.autoDiscover = false;

    // Initialize Dropzone
    var myDropzone = new Dropzone("#my-dropzone", {
        url: "{{route('project.uploadProjectImages', ['id'=>$project->id])}}", // Set the url for your upload script
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
        },
        autoProcessQueue: false, // Prevent Dropzone from uploading automatically
        addRemoveLinks: true,
        parallelUploads: 100 // Allow multiple uploads at the same time
    });

    // Handle the form submission
    document.querySelector("#form-data").addEventListener("submit", function(e) {
        e.preventDefault();

        // Get extra data
        var extraFieldData = $("#images_type").val();
        if (extraFieldData == "") {
            alert('Please select type!');
            return false;
        }

        // Append extra data to the form
        myDropzone.on("sending", function(file, xhr, formData) {
            formData.append("images_type", extraFieldData);
        });

        // Process the Dropzone queue
        myDropzone.processQueue();
    });

    // Event listener for when all files have been processed
    myDropzone.on("queuecomplete", function() {
        // You can do additional tasks here, like showing a success message or redirecting
        alert("All files have been uploaded successfully!");
        window.location.reload();
    });

    // Event listener for handling errors
    myDropzone.on("error", function(file, errorMessage) {
        alert("Error uploading file: " + errorMessage);
    });

</script>
<script>
    $(".markcomplete").click(function() {
        var id = $(this).data('id');
        $("#milestone_c_id").val(id)
        $("#myModal").modal("show");
    });


    /*
var table = $("#kt_table_users").DataTable({
    "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
    "paging": false,//Dont want paging                
    "bPaginate": false,//Dont want paging
});

$('#mySearch').on('input', function() {
  table.search($(this).val()).draw();
})*/

    $("#report").click(function() {
        $("#kt_chat_contacts_header").hide();
        $("#report_btns").show();
        $(".form-check").show();
    })

</script>
@endsection
